function lidar_proc=read_Proc_profiles(fid,declination)
% Filename:	C:\Lidar\Data\Proc\2016\201609\20160913\User1_70_20160913_004206.hpl
% System ID:	70
% Number of gates:	828
% Range gate length (m):	36.0
% Gate length (pts):	12
% Pulses/ray:	60000
% No. of rays in file:	17
% Scan type:	User file 1
% Focus range:	1500
% Start time:	20160913 00:42:15.06
% Resolution (m/s):	0.0191
% Altitude of measurement (center of gate) = (range gate + 0.5) * Gate length
% Data line 1: Decimal time (hours)  Azimuth (degrees)  Elevation (degrees)
% f9.6,1x,f6.2,1x,f6.2
% Data line 2: Range Gate  Doppler (m/s)  Intensity (SNR + 1)  Beta (m-1 sr-1)
% i3,1x,f6.4,1x,f8.6,1x,e12.6 - repeat for no. gates
% ****
C=textscan(fid,'%s %s',1);
lidar_proc.orig_filename=C{1,2};
C=textscan(fid,'%s %s %d',1);
lidar_proc.system_id=C{1,3};
C=textscan(fid,'%s %s %s %d',1);
lidar_proc.number_of_gates=C{1,4};
C=textscan(fid,'%s %s %s %s %n',1);
lidar_proc.range_gate_length=C{1,5};
C=textscan(fid,'%s %s %s %d',1);
lidar_proc.gatelengthinpts=C{1,4};
if lidar_proc.number_of_gates>300
    lidar_proc.ranges=lidar_proc.range_gate_length/2+[0:lidar_proc.number_of_gates-1]*3;
else
    lidar_proc.ranges=lidar_proc.range_gate_length/2+[0:lidar_proc.number_of_gates-1]*lidar_proc.range_gate_length;
end
lidar_proc.ranges=double(lidar_proc.ranges);
C=textscan(fid,'%s %d',1);
lidar_proc.pulses_per_ray=C{1,2};
C=textscan(fid,'%s %s %s %s %s %d',1);
lidar_proc.number_of_rays=C{1,6};
C=textscan(fid,'%s %s %s %s %s',1);
lidar_proc.scan_type=[char(C{1,3}),' ',char(C{1,4}),' ',char(C{1,5})];
C=textscan(fid,'%s %s %d',1);
lidar_proc.focus_range=C{1,3};
C=textscan(fid,'%s %s %s %s',1);
temp=[char(C{1,3}),' ',char(C{1,4})];
lidar_proc.start_time=datenum(char(temp(1:end-3)),'yyyymmdd HH:MM:SS');
C=textscan(fid,'%s %s %n',1);
lidar_proc.resolution=C{1,3};
C=textscan(fid,'%s %s %s %s %s %s %s %s %s %s %s %s %s %s',1);
C=textscan(fid,'%s %s %s %s %s %s %s %s %s %s',1);
C=textscan(fid,'%s',1);
C=textscan(fid,'%s %s %s %s %s %s %s %s %s %s %s %s %s %s',1);
C=textscan(fid,'%s %s %s %s %s %s',1);
C=textscan(fid,'%s',1);

for j=1:lidar_proc.number_of_rays
    C=textscan(fid,'%n %n %n',1);
    lidar_proc.lidar_decimal_time(j)=C{1,1};
    azimuth(j)=C{1,2};
    elevation(j)=C{1,3};
    for k=1:lidar_proc.number_of_gates
        C=textscan(fid,'%d %n %n %n',1);
        lidar_proc.azimuth(j,k)=azimuth(j)+declination;
        lidar_proc.elevation(j,k)=elevation(j);
        lidar_proc.RWS(j,k)=C{1,2};
        lidar_proc.SNR(j,k)=C{1,3};
        lidar_proc.Beta(j,k)=C{1,4};
    end
end
lidar_proc.xd=(sin(azimuth'*pi/180).*cos(elevation'*pi/180))*double(lidar_proc.ranges);
lidar_proc.yd=(cos(azimuth'*pi/180).*cos(elevation'*pi/180))*double(lidar_proc.ranges);
lidar_proc.zd=(sin(elevation'*pi/180))*double(lidar_proc.ranges);
return









